function toggleEyeAction () {
  $('.js-eye-btn').on('click', function () {
    if ($('.js-password-input').attr('type') === 'password') {
      $('.js-password-input').prop('type', 'text')
    } else {
      $('.js-password-input').prop('type', 'password');
    }
  })
};

function loginAction () {
  $('.js-login-btn').on('click', function () {
    $('.js-login-error').html('');

    const domain = $.trim($('.js-domain-input').val());
    if (domain == '') {
      $('.js-login-error').html('Vui lòng nhập tên cửa hàng');
      $('.js-domain-input').focus();
      return;
    }

    $('.js-login-btn').prop('disabled', true);
    $('.js-login-btn').find('.spinner-border').removeClass('d-none');

    pywebview.api.check_domain(domain).then(function (response) {
      if (response.status == 404) {
        $('.js-login-btn').prop('disabled', false);
        $('.js-login-btn').find('.spinner-border').addClass('d-none');
        $('.js-login-error').html('Cửa hàng chưa được đăng ký trong hệ thống.');
        $('.js-domain-input').focus();
      }
    });
  });
};

function sellOffline () {
  $('.js-selloffline-btn').on('click', function () {
    pywebview.api.sellOfflineChannel().then(function (response) {});
  });
};

function networkNotify () {
  try {
    window.addEventListener('online', function (e) {
      pywebview.api.notifyOnlineChannel().then(function (response) {});
    });

    window.addEventListener('offline', function (e) {
      pywebview.api.notifyOfflineChannel().then(function (response) {});
    });
  } catch (error) {
    console.log(error);
  }
};

$(function () {
  $('body *').on('touchstart', function () {});
  toggleEyeAction();
  loginAction();
  sellOffline();
});
